/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IAnnotation;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ontology.Annotation;

public class BiNGOAnnotationFlatFileReader
implements IAnnotation {
    private Annotation annotation;
    private String annotationType;
    private String species;
    private String curator;
    private String filename;
    private Map<Integer, Integer> synonymHash;
    private Map<String, HashSet<String>> alias;
    private boolean orphansFound = false;
    private boolean consistency = false;

    BiNGOAnnotationFlatFileReader(String filename, String mappingFile, Map<Integer, Integer> synonymHash) {
        this.filename = filename;
        this.synonymHash = synonymHash;
        this.parse();
        if (mappingFile != null) {
            this.retrieveAlias(mappingFile);
        }
        System.out.println("Reading done!");
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void parseHeader(String firstLine) {
        String[] tokens = firstLine.trim().split("\\)");
        Object errorMsg = "error in AnnotationFlatFileReader.parseHeader ().\n";
        errorMsg = (String)errorMsg + "First line of " + this.filename + " must have form:\n";
        errorMsg = (String)errorMsg + "   (species=Homo sapiens) (type=Biological Process) (curator=GO)\n";
        errorMsg = (String)errorMsg + "instead found:\n";
        errorMsg = (String)errorMsg + "   " + firstLine + "\n";
        if (tokens.length != 3) {
            throw new IllegalArgumentException((String)errorMsg);
        }
        for (String token : tokens) {
            String[] subTokens = token.split("=");
            if (subTokens.length != 2) {
                throw new IllegalArgumentException((String)errorMsg);
            }
            String name = subTokens[0].trim();
            String value = subTokens[1].trim();
            if (name.equalsIgnoreCase("(species")) {
                this.species = value;
                continue;
            }
            if (name.equalsIgnoreCase("(type")) {
                this.annotationType = value;
                continue;
            }
            if (!name.equalsIgnoreCase("(curator")) continue;
            this.curator = value;
        }
    }

    private void parse() {
        HashSet<Integer> orphans = new HashSet<Integer>();
        this.alias = new HashMap<String, HashSet<String>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filename));){
            String line;
            boolean isHeader = true;
            while ((line = reader.readLine()) != null) {
                if (isHeader) {
                    this.parseHeader(line);
                    this.annotation = new Annotation(this.species, this.annotationType, this.curator);
                    isHeader = false;
                    continue;
                }
                String[] tokens = line.split("=");
                String entityName = tokens[0].trim().toUpperCase();
                int id = this.stringToInt(tokens[1].trim());
                Integer mainId = this.synonymHash.get(id);
                if (mainId != null) {
                    if (entityName.length() != 0 && id != -1) {
                        this.annotation.add(entityName, mainId);
                        HashSet<String> tmp = new HashSet<String>();
                        tmp.add(entityName);
                        this.alias.put(entityName, tmp);
                    }
                    this.consistency = true;
                    continue;
                }
                orphans.add(id);
                this.orphansFound = true;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void retrieveAlias(String mappingFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(mappingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] fields;
                for (String f : fields = line.trim().split("\\t")) {
                    if (this.alias.containsKey(f)) {
                        HashSet<String> temp = this.alias.get(f);
                        temp.addAll(Arrays.asList(fields));
                        this.alias.put(f, temp);
                        continue;
                    }
                    this.alias.put(f, new HashSet<String>(Arrays.asList(fields)));
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Map<String, HashSet<String>> getAlias() {
        return this.alias;
    }

    @Override
    public boolean getConsistency() {
        return this.consistency;
    }

    @Override
    public boolean getOrphans() {
        return this.orphansFound;
    }
}

