/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IOntologyReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ontology.Ontology;
import ontology.OntologyTerm;

public class BiNGOOntologyOboReader
implements IOntologyReader {
    private Ontology ontology;
    private Ontology fullOntology;
    private String curator = "unknown";
    private String ontologyType = "unknown";
    private String namespace;
    private String filename;
    private HashMap<Integer, Integer> synonymHash;
    private Map<String, String> termToNamespace;

    public BiNGOOntologyOboReader(File file, String namespace) {
        this(file.getPath(), namespace);
    }

    public BiNGOOntologyOboReader(String filename, String namespace) {
        this.filename = filename;
        this.namespace = namespace;
        this.synonymHash = new HashMap();
        this.parse();
    }

    public BiNGOOntologyOboReader(String fileName, String namespace, Map<String, String> termToNamespace) {
        this(fileName, namespace);
        this.termToNamespace = termToNamespace;
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private boolean parseHeader(String line) {
        if (line.startsWith("ontology: go")) {
            this.ontologyType = "GO";
        } else if (line.startsWith("ontology: hp")) {
            this.ontologyType = "HPO";
        }
        if (!this.ontologyType.equals("unknown")) {
            this.ontology = new Ontology(this.curator, this.ontologyType);
            this.fullOntology = new Ontology(this.curator, this.ontologyType);
        }
        this.curator = "unknown";
        return !line.trim().equals("[Term]");
    }

    /*
     * Unable to fully structure code
     */
    private void parse() {
        name = "";
        id = "";
        geneNamespaces = new HashSet<String>();
        alt_id = new HashSet<String>();
        is_a = new HashSet<String>();
        part_of = new HashSet<String>();
        obsolete = false;
        update = false;
        isHeader = true;
        try {
            reader = new BufferedReader(new FileReader(this.filename));
lbl12:
            // 3 sources

            try {
                while ((line = reader.readLine()) != null) {
                    block39: {
                        if (isHeader) {
                            isHeader = this.parseHeader(line);
                            continue;
                        }
                        if (line.trim().equals("[Typedef]")) {
                            return;
                        }
                        if (update) {
                            name = "";
                            id = "";
                            geneNamespaces.clear();
                            alt_id.clear();
                            is_a.clear();
                            part_of.clear();
                            update = false;
                            obsolete = false;
                        }
                        if (line.trim().equals("[Term]") || line.trim().equals("[Typedef]")) continue;
                        if (!line.trim().equals("")) {
                            ref = line.substring(0, line.indexOf(":")).trim();
                            value = line.substring(line.indexOf(":") + 1).trim();
                            var14_17 = ref;
                            var15_18 = -1;
                            switch (var14_17.hashCode()) {
                                case 3373707: {
                                    if (!var14_17.equals("name")) break;
                                    var15_18 = 0;
                                    break;
                                }
                                case 1252218203: {
                                    if (!var14_17.equals("namespace")) break;
                                    var15_18 = 1;
                                    break;
                                }
                                case -891529694: {
                                    if (!var14_17.equals("subset")) break;
                                    var15_18 = 2;
                                    break;
                                }
                                case 3355: {
                                    if (!var14_17.equals("id")) break;
                                    var15_18 = 3;
                                    break;
                                }
                                case -1414648975: {
                                    if (!var14_17.equals("alt_id")) break;
                                    var15_18 = 4;
                                    break;
                                }
                                case 3241612: {
                                    if (!var14_17.equals("is_a")) break;
                                    var15_18 = 5;
                                    break;
                                }
                                case -261851592: {
                                    if (!var14_17.equals("relationship")) break;
                                    var15_18 = 6;
                                    break;
                                }
                                case -377382642: {
                                    if (!var14_17.equals("is_obsolete")) break;
                                    var15_18 = 7;
                                }
                            }
                            switch (var15_18) {
                                case 0: {
                                    name = value.trim();
                                    break;
                                }
                                case 1: {
                                    geneNamespaces.add(value.trim());
                                    break;
                                }
                                case 2: {
                                    geneNamespaces.add(value.trim());
                                    break;
                                }
                                case 3: {
                                    id = value.trim().substring(3);
                                    break;
                                }
                                case 4: {
                                    alt_id.add(value.trim().substring(3));
                                    break;
                                }
                                case 5: {
                                    is_a.add(value.split("!")[0].trim().substring(3));
                                    break;
                                }
                                case 6: {
                                    if (!value.startsWith("part_of")) break;
                                    part_of.add(value.substring(7).split("!")[0].trim().substring(3));
                                    break;
                                }
                                case 7: {
                                    if (!value.trim().equals("true")) break;
                                    obsolete = true;
                                    break;
                                }
                            }
                            continue;
                        }
                        update = true;
                        if (obsolete) continue;
                        if (!this.namespace.equals("---") && !geneNamespaces.contains(this.namespace)) break block39;
                        id2 = new Integer(id);
                        this.synonymHash.put(id2, id2);
                        term = new OntologyTerm(name, id2);
                        if (this.ontology.containsTerm(id2)) continue;
                        this.ontology.add(term);
                        this.fullOntology.add(term);
                        for (String s : alt_id) {
                            this.synonymHash.put(new Integer(s), id2);
                        }
                        for (String s : is_a) {
                            term.addParent(new Integer(s));
                        }
                        for (String s : part_of) {
                            term.addContainer(new Integer(s));
                        }
                        ** GOTO lbl12
                    }
                    id2 = new Integer(id);
                    term = new OntologyTerm(name, id2);
                    if (this.fullOntology.containsTerm(id2)) continue;
                    this.fullOntology.add(term);
                    for (String s : is_a) {
                        term.addParent(new Integer(s));
                    }
                    for (String s : part_of) {
                        term.addContainer(new Integer(s));
                    }
                    ** GOTO lbl12
                }
                this.reRouteConnections();
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            System.out.println("Unable to read ontology file " + this.filename);
        }
    }

    private void reRouteConnections() {
        if (!(this.namespace.equals("biological_process") || this.namespace.equals("molecular_function") || this.namespace.equals("cellular_component") || this.namespace.equals("---") || this.namespace.equals("phenotypic_abnormality") || this.namespace.equals("clinical_modifier") || this.namespace.equals("mode_of_inheritance") || this.namespace.equals("clinical_course"))) {
            for (Integer j : this.ontology.getTerms().keySet()) {
                OntologyTerm o = this.ontology.getTerm(j);
                HashSet<OntologyTerm> ancestors = this.findNearestAncestors(new HashSet<OntologyTerm>(), j);
                HashSet<OntologyTerm> prunedAncestors = new HashSet<OntologyTerm>(ancestors);
                for (OntologyTerm o2 : ancestors) {
                    HashSet<OntologyTerm> o2Ancestors = this.getAllAncestors(new HashSet<OntologyTerm>(), o2);
                    for (OntologyTerm o3 : o2Ancestors) {
                        if (!ancestors.contains(o3)) continue;
                        prunedAncestors.remove(o3);
                    }
                }
                for (OntologyTerm o2 : prunedAncestors) {
                    o.addParent(o2.getId());
                }
            }
        }
    }

    private HashSet<OntologyTerm> findNearestAncestors(HashSet<OntologyTerm> ancestors, Integer k) {
        int[] nArray = this.fullOntology.getTerm(k).getParentsAndContainers();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (!this.ontology.containsTerm(i2)) {
                this.findNearestAncestors(ancestors, i2);
                continue;
            }
            ancestors.add(this.ontology.getTerm(i2));
        }
        return ancestors;
    }

    private HashSet<OntologyTerm> getAllAncestors(HashSet<OntologyTerm> ancestors, OntologyTerm o) {
        int[] nArray = o.getParentsAndContainers();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            ancestors.add(this.fullOntology.getTerm(i2));
            this.getAllAncestors(ancestors, this.fullOntology.getTerm(i2));
        }
        return ancestors;
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }

    @Override
    public HashMap<Integer, Integer> getSynonymHash() {
        return this.synonymHash;
    }

    @Override
    public String getOntologyType() {
        return this.ontologyType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void makeOntologyFile(String outputDir) {
        File f = new File(outputDir, "GO_" + this.namespace);
        try {
            FileWriter fw = new FileWriter(f);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("(curator=bingo)(type=namespace)");
            for (Integer a : this.ontology.getTerms().keySet()) {
                OntologyTerm o = this.fullOntology.getTerm(new Integer(((Object)a).toString()));
                pw.print(o.getId() + " = " + o.getName());
                boolean ok = false;
                for (int i : o.getParentsAndContainers()) {
                    if (!ok) {
                        pw.print("[isa: ");
                        ok = true;
                    }
                    pw.print(i + " ");
                }
                if (ok) {
                    pw.println("]");
                    continue;
                }
                pw.println();
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

