/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.AnnotationParser;
import bingo.BingoAlgorithm;
import bingo.CalculateCorrectionTask;
import bingo.CalculateTestTask;
import bingo.Constants;
import bingo.CreateBiNGOFile;
import bingo.StatisticsDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class BingoRunner
implements Runnable {
    private AnnotationParser parser;
    private StatisticsDescriptor descriptor;
    private String ontologyType;
    private Set<String> ecCodes;
    private Map<String, Set<String>> redundantIDs = new HashMap<String, Set<String>>();
    private String selectedNodes;
    private String clusterName;
    private String outputDir;
    private int numberOfClusters;
    private static AtomicInteger counter = new AtomicInteger(1);

    public BingoRunner() {
        this.ecCodes = new HashSet<String>();
        this.ecCodes.add("IEA");
        this.ecCodes.add("ISS");
        this.ecCodes.add("TAS");
        this.ecCodes.add("IDA");
        this.ecCodes.add("IGI");
        this.ecCodes.add("IMP");
        this.ecCodes.add("IEP");
        this.ecCodes.add("ND");
        this.ecCodes.add("RCA");
        this.ecCodes.add("IPI");
        this.ecCodes.add("NAS");
        this.ecCodes.add("IC");
        this.ecCodes.add("NR");
    }

    public BingoRunner(AnnotationParser parser, StatisticsDescriptor descriptor, String selectedNodes, String clusterName, String outputDir, int numberOfClusters) {
        this();
        this.parser = parser;
        this.descriptor = descriptor;
        this.selectedNodes = selectedNodes;
        this.clusterName = clusterName;
        this.outputDir = outputDir;
        this.numberOfClusters = numberOfClusters;
    }

    public void actionPerformed() {
        Set<String> aNodes;
        HashSet<String> sNodes;
        HashSet<String> noClassificationsSet = new HashSet<String>();
        this.redundantIDs = new HashMap<String, Set<String>>();
        if (this.descriptor.getReferenceSet().equals(Constants.GENOME.getConstant())) {
            sNodes = this.getSelectedCanonicalNamesFromTextArea();
            aNodes = this.getAllCanonicalNamesFromAnnotation(sNodes);
        } else {
            sNodes = this.getSelectedCanonicalNamesFromTextArea();
            aNodes = this.getAllCanonicalNamesFromReferenceSet(this.descriptor.getReferenceSet(), sNodes);
        }
        int[] testData = this.getClassificationsFromVector(sNodes, noClassificationsSet);
        boolean noElementsInTestData = false;
        try {
            int n = testData[0];
        }
        catch (Exception ex) {
            noElementsInTestData = true;
        }
        if (!noElementsInTestData) {
            this.performCalculations(sNodes, aNodes, noClassificationsSet);
            noClassificationsSet.clear();
        } else {
            System.out.println("The selected annotation does not produce any\nclassifications for the selected nodes.\nMaybe you chose the wrong type of gene identifier ?You can use DiNGO mapping tool!");
        }
    }

    public HashSet<String> getSelectedCanonicalNamesFromTextArea() {
        String[] nodes = this.selectedNodes.split("\\s+");
        HashSet<String> canonicalNameVector = new HashSet<String>();
        HashSet<Set> mapNames = new HashSet<Set>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].length() == 0 || canonicalNameVector.contains(nodes[i].toUpperCase())) continue;
            if (mapNames.contains(this.parser.getAlias().get(nodes[i].toUpperCase()))) {
                this.redundantIDs.put(nodes[i].toUpperCase(), (Set<String>)this.parser.getAlias().get(nodes[i].toUpperCase()));
            }
            if (this.parser.getAlias().get(nodes[i]) != null) {
                mapNames.add(this.parser.getAlias().get(nodes[i]));
            }
            canonicalNameVector.add(nodes[i]);
        }
        return canonicalNameVector;
    }

    public Set<String> getAllCanonicalNamesFromAnnotation(Set<String> selectedNodes) {
        String[] nodes = this.parser.getAnnotation().getNames();
        HashSet<String> canonicalNameVector = new HashSet<String>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].length() == 0) continue;
            canonicalNameVector.add(nodes[i].toUpperCase());
        }
        Map<String, HashSet<String>> alias = this.parser.getAlias();
        Iterator<String> it2 = selectedNodes.iterator();
        while (it2.hasNext()) {
            String name = String.valueOf(it2.next());
            Set tmp = alias.get(name);
            if (tmp == null) continue;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                canonicalNameVector.remove(String.valueOf(it.next()));
            }
            canonicalNameVector.add(name);
        }
        return canonicalNameVector;
    }

    public Set<String> getAllCanonicalNamesFromReferenceSet(String refSet, Set<String> selectedNodes) {
        HashSet<String> nodes = this.parseReferenceSet(refSet);
        HashSet<String> canonicalNameVector = new HashSet<String>();
        for (String s : nodes) {
            if (s.length() == 0) continue;
            canonicalNameVector.add(s.toUpperCase());
        }
        Map<String, HashSet<String>> alias = this.parser.getAlias();
        Iterator<String> it2 = selectedNodes.iterator();
        while (it2.hasNext()) {
            String name = String.valueOf(it2.next());
            Set tmp = alias.get(name);
            if (tmp == null) continue;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                canonicalNameVector.remove(String.valueOf(it.next()));
            }
            canonicalNameVector.add(name);
        }
        return canonicalNameVector;
    }

    public HashSet<String> parseReferenceSet(String refSetFile) {
        HashSet<String> refSet = new HashSet<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(new File(refSetFile)));
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.trim().split("\t");
                refSet.add(tokens[0].trim().toUpperCase());
            }
        }
        catch (IOException e) {
            System.out.println("Error reading reference file: " + String.valueOf(e));
        }
        return refSet;
    }

    public int[] getClassificationsFromVector(Set<String> canonicalNameVector, Set<String> noClassificationsSet) {
        HashSet<CallSite> classificationsVector = new HashSet<CallSite>();
        Map<String, HashSet<String>> alias = this.parser.getAlias();
        Iterator<String> it2 = canonicalNameVector.iterator();
        while (it2.hasNext()) {
            String name = String.valueOf(it2.next());
            Set identifiers = alias.get(name);
            HashSet<CallSite> cls = new HashSet<CallSite>();
            if (identifiers != null) {
                Iterator it = identifiers.iterator();
                while (it.hasNext()) {
                    int[] goLabelsName = this.parser.getAnnotation().getClassifications(String.valueOf(it.next()));
                    for (int t = 0; t < goLabelsName.length; ++t) {
                        cls.add((CallSite)((Object)("" + goLabelsName[t])));
                    }
                }
            }
            if (cls.isEmpty()) {
                noClassificationsSet.add(name);
            }
            Iterator it3 = cls.iterator();
            while (it3.hasNext()) {
                classificationsVector.add((CallSite)((Object)String.valueOf(it3.next())));
            }
        }
        int[] classifications = new int[classificationsVector.size()];
        it2 = classificationsVector.iterator();
        int i = 0;
        while (it2.hasNext()) {
            classifications[i] = Integer.parseInt(String.valueOf(it2.next()));
            ++i;
        }
        return classifications;
    }

    public void performCalculations(Set<String> selectedNodes, Set<String> allNodes, Set<String> noClassificationsSet) {
        Map<Integer, String> testMap = null;
        Map<String, String> correctionMap = null;
        BingoAlgorithm algorithm = new BingoAlgorithm(this.parser.getAnnotation(), this.parser.getOntology(), this.descriptor, this.parser.getAlias(), selectedNodes, allNodes);
        CalculateTestTask test = algorithm.calculate_distribution();
        try {
            test.calculate();
            testMap = test.getTestMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CalculateCorrectionTask correction = null;
        if (!this.descriptor.getCorrectionTest().equals(Constants.NONE.getConstant())) {
            correction = algorithm.calculate_corrections(testMap);
            try {
                correction.calculate();
            }
            catch (Exception e) {
                System.out.println("NULL");
                e.printStackTrace();
            }
        }
        if (correction != null && !this.descriptor.getTest().equals(Constants.NONE.getConstant())) {
            correctionMap = correction.getCorrectionMap();
        }
        CreateBiNGOFile file = new CreateBiNGOFile(test, correction, this.parser, this.descriptor, selectedNodes, noClassificationsSet, this.outputDir, this.clusterName, Constants.CATEGORY_CORRECTION.getConstant());
        file.writeToFile();
        int count = counter.getAndIncrement();
        double percent = 100.0 * (double)count / (double)this.numberOfClusters;
        System.out.print(count + " / " + this.numberOfClusters + " " + (int)percent + "% completed\r");
    }

    @Override
    public void run() {
        this.actionPerformed();
    }
}

