/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public abstract class CalculateCorrectionTask {
    private HashEntry[] hash;
    private String[] ordenedGOLabels;
    private String[] ordenedPvalues;
    protected int numberOfTests;

    public CalculateCorrectionTask(Map golabelstopvalues) {
        Iterator iteratorGoLabelsSet = golabelstopvalues.keySet().iterator();
        this.hash = new HashEntry[golabelstopvalues.size()];
        int i = 0;
        while (iteratorGoLabelsSet.hasNext()) {
            String goLabel = iteratorGoLabelsSet.next().toString();
            this.hash[i] = new HashEntry(goLabel, golabelstopvalues.get(new Integer(goLabel)).toString());
            ++i;
        }
        Arrays.sort(this.hash, new Comparator<HashEntry>(){

            @Override
            public int compare(HashEntry o1, HashEntry o2) {
                return new BigDecimal(o1.value).compareTo(new BigDecimal(o2.value));
            }
        });
        this.numberOfTests = golabelstopvalues.size();
        this.parse();
    }

    private void parse() {
        this.ordenedGOLabels = new String[this.numberOfTests];
        this.ordenedPvalues = new String[this.numberOfTests];
        for (int i = 0; i < this.numberOfTests; ++i) {
            this.ordenedGOLabels[i] = this.hash[i].key;
            this.ordenedPvalues[i] = this.hash[i].value;
        }
    }

    protected String[] getOrdenedPvalues() {
        return this.ordenedPvalues;
    }

    protected String[] getOrdenedGOLabels() {
        return this.ordenedGOLabels;
    }

    abstract Map<String, String> getCorrectionMap();

    public abstract void calculate();

    private final class HashEntry {
        public String key;
        public String value;

        public HashEntry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

