/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IDistribution;
import cern.jet.stat.Gamma;

public class HypergeometricDistribution
implements IDistribution {
    private boolean isOver = true;
    private int x;
    private int bigX;
    private int n;
    private int bigN;

    public HypergeometricDistribution(int x, int bigX, int n, int bigN) {
        this.x = x;
        this.bigX = bigX;
        this.n = n;
        this.bigN = bigN;
    }

    public HypergeometricDistribution(int x, int bigX, int n, int bigN, boolean isOver) {
        this(x, bigX, n, bigN);
        this.isOver = isOver;
    }

    private String calculateHypergDistr() {
        if (this.bigN >= 2) {
            int newX;
            double sum = 0.0;
            int mode = (this.bigX + 1) * (this.n + 1) / (this.bigN + 2);
            int n = newX = !this.isOver ? this.x + 1 : this.x;
            if (newX >= mode) {
                for (int i = newX; this.bigN - this.n >= this.bigX - i && i <= Math.min(this.bigX, this.n); ++i) {
                    double pdfi = Math.exp(Gamma.logGamma(this.n + 1) - Gamma.logGamma(i + 1) - Gamma.logGamma(this.n - i + 1) + Gamma.logGamma(this.bigN - this.n + 1) - Gamma.logGamma(this.bigX - i + 1) - Gamma.logGamma(this.bigN - this.n - this.bigX + i + 1) - Gamma.logGamma(this.bigN + 1) + Gamma.logGamma(this.bigX + 1) + Gamma.logGamma(this.bigN - this.bigX + 1));
                    sum += pdfi;
                }
                if (!this.isOver) {
                    sum = 1.0 - sum;
                }
            } else {
                for (int i = newX - 1; this.bigN - this.n >= this.bigX - i && i >= 0; --i) {
                    double pdfi = Math.exp(Gamma.logGamma(this.n + 1) - Gamma.logGamma(i + 1) - Gamma.logGamma(this.n - i + 1) + Gamma.logGamma(this.bigN - this.n + 1) - Gamma.logGamma(this.bigX - i + 1) - Gamma.logGamma(this.bigN - this.n - this.bigX + i + 1) - Gamma.logGamma(this.bigN + 1) + Gamma.logGamma(this.bigX + 1) + Gamma.logGamma(this.bigN - this.bigX + 1));
                    sum += pdfi;
                }
                if (this.isOver) {
                    sum = 1.0 - sum;
                }
            }
            return String.valueOf(sum);
        }
        return String.valueOf(1);
    }

    public boolean getIsOver() {
        return this.isOver;
    }

    public void setIsOver(boolean newValue) {
        this.isOver = newValue;
    }

    @Override
    public String calculateDistribution() {
        return this.calculateHypergDistr();
    }
}

