/*
 * Decompiled with CFR 0.152.
 */
package hpoannotation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import update.LocalFilesManager;

public class HpoAnnotationReader {
    private final String hpoAnnotationFile;
    private String formatVersion;
    private Date releaseDate;

    public HpoAnnotationReader(String hpoAnnotationFile) {
        this.hpoAnnotationFile = hpoAnnotationFile;
    }

    public Map<String, String> mapTermToSubontology() {
        HashMap<String, String> termToSubontology = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.hpoAnnotationFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("DatabaseID") || line.startsWith("database_id")) {
                    if (!line.startsWith("#version:") && !line.startsWith("#date:")) continue;
                    this.releaseDate = LocalFilesManager.convertStringToDate(line.split(":")[1], "yyyy-MM-dd");
                    continue;
                }
                String[] fields = line.split("\\t");
                termToSubontology.put(fields[3], fields[10]);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return termToSubontology;
        }
        return termToSubontology;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getHpoAnnotationFile() {
        return this.hpoAnnotationFile;
    }
}

