/*
 * Decompiled with CFR 0.152.
 */
package ontology;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import ontology.FlattenIntVectors;
import ontology.OntologyDescription;
import ontology.OntologyTerm;

public class Ontology
implements Serializable {
    protected String curator;
    protected String ontologyType;
    protected HashMap<Integer, OntologyTerm> termHash;

    public Ontology(String curator, String ontologyType) {
        this.curator = curator;
        this.ontologyType = ontologyType;
        this.termHash = new HashMap();
    }

    public String getCurator() {
        return this.curator;
    }

    public String getType() {
        return this.ontologyType;
    }

    public void add(OntologyTerm newTerm) {
        this.termHash.put(newTerm.getId(), newTerm);
    }

    public int size() {
        return this.termHash.size();
    }

    public HashMap<Integer, OntologyTerm> getTerms() {
        return this.termHash;
    }

    public boolean containsTerm(int id) {
        return this.termHash.containsKey(id);
    }

    public OntologyTerm getTerm(int id) {
        return this.termHash.get(id);
    }

    public int[][] getAllHierarchyPaths(int termID) {
        Vector flattenedList = this.getAllHierarchyPathsAsVector(termID);
        int size = flattenedList.size();
        int[][] result = new int[size][];
        for (int i = 0; i < size; ++i) {
            Vector integerList = (Vector)flattenedList.get(i);
            int max = integerList.size();
            result[i] = new int[max];
            for (int j = 0; j < max; ++j) {
                int indexForReversingOrder = max - j - 1;
                result[i][j] = (Integer)integerList.get(indexForReversingOrder);
            }
        }
        return result;
    }

    public String[][] getAllHierarchyPathsAsNames(int termID) {
        int[][] hierarchy = this.getAllHierarchyPaths(termID);
        String[][] result = new String[hierarchy.length][];
        for (int i = 0; i < hierarchy.length; ++i) {
            int[] path = hierarchy[i];
            int max = path.length;
            result[i] = new String[max];
            for (int j = 0; j < path.length; ++j) {
                result[i][j] = this.getTerm(path[j]).getName();
            }
        }
        return result;
    }

    protected Vector getAllHierarchyPathsAsVector(int termID) {
        Vector nestedLists = this.recursiveGetPath(termID, new Vector<Integer>());
        if (nestedLists.isEmpty()) {
            return nestedLists;
        }
        System.out.println(nestedLists.toString());
        FlattenIntVectors flattener = new FlattenIntVectors(nestedLists);
        Vector flattenedList = flattener.getResult();
        System.out.println("Flattened list: " + flattenedList.toString());
        return flattenedList;
    }

    protected Vector recursiveGetPath(int termID, Vector<Integer> path) {
        Integer ID = termID;
        if (this.termHash != null && this.termHash.containsKey(ID)) {
            OntologyTerm term = this.termHash.get(ID);
            int parentCount = term.numberOfParentsAndContainers();
            path.addElement(ID);
            if (parentCount == 0) {
                return path;
            }
            if (parentCount == 1) {
                int parentID = term.getParentsAndContainers()[0];
                return this.recursiveGetPath(parentID, path);
            }
            Vector<Vector> newPath = new Vector<Vector>();
            for (int p = 0; p < parentCount; ++p) {
                Vector subPath = (Vector)path.clone();
                int parent = term.getParentsAndContainers()[p];
                newPath.addElement(this.recursiveGetPath(parent, subPath));
            }
            return newPath;
        }
        return path;
    }

    protected Vector oldRecursiveGetPath(int termID, Vector path) {
        Integer ID = termID;
        if (this.termHash != null && this.termHash.containsKey(ID)) {
            OntologyTerm term = this.termHash.get(ID);
            int parentCount = term.numberOfParentsAndContainers();
            if (parentCount == 0) {
                path.addElement(ID);
                return path;
            }
            if (parentCount == 1) {
                path.addElement(ID);
                int parentID = term.getParentsAndContainers()[0];
                return this.recursiveGetPath(parentID, path);
            }
            path.addElement(ID);
            Vector<Vector> newPath = new Vector<Vector>();
            Vector path1 = (Vector)path.clone();
            Vector path2 = (Vector)path.clone();
            int parent1 = term.getParentsAndContainers()[0];
            int parent2 = term.getParentsAndContainers()[1];
            newPath.addElement(this.recursiveGetPath(parent1, path1));
            newPath.addElement(this.recursiveGetPath(parent2, path2));
            return newPath;
        }
        return path;
    }

    public OntologyDescription getDescription() {
        return new OntologyDescription(this.curator, this.ontologyType);
    }

    public HashMap<Integer, OntologyTerm> getTermHash() {
        return this.termHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ontology: ").append(this.ontologyType).append("\n");
        sb.append("curator:  ").append(this.curator).append("\n");
        return sb.toString();
    }
}

