/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import propagation.Term;

public class OboParser {
    private final String fileName;
    private String formatVersion;
    private String ReleaseDate;
    private final List<Term> leafTerms = new ArrayList<Term>();
    private final List<Term> nonLeafTerms = new ArrayList<Term>();

    public OboParser(String fileName) {
        this.fileName = fileName;
    }

    private Term initTerm(String OboTerm) {
        String[] details = OboTerm.split("\\r?\\n");
        String id = "";
        String name = "";
        String namespace = "";
        ArrayList<Term> parents = new ArrayList<Term>();
        ArrayList<String> altIds = new ArrayList<String>();
        boolean IsObsolete = false;
        for (String d : details) {
            if (d.startsWith("id:")) {
                id = d.split(":")[2].trim();
            }
            if (d.startsWith("alt_id:")) {
                altIds.add(d.split(":")[2].trim());
            }
            if (d.startsWith("name:")) {
                name = d.split(":")[1].trim();
            }
            if (d.startsWith("namespace:")) {
                namespace = d.split(":")[1].trim();
            }
            if (d.startsWith("is_obsolete: true")) {
                IsObsolete = true;
            }
            if (d.startsWith("is_a:")) {
                Term term1 = new Term(d.split("!")[0].substring(9).trim(), d.split("!")[1].trim());
                parents.add(term1);
                this.nonLeafTerms.add(term1);
            }
            if (!d.contains(" part_of ")) continue;
            String[] fields = d.split("\\s");
            String termID = fields[2];
            String termName = fields[4];
            parents.add(new Term(termID, termName));
        }
        Term term = new Term(IsObsolete, id, name, namespace, parents);
        term.setAltIDList(altIds);
        return term;
    }

    public String parseOboFile() {
        StringBuilder bText = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.fileName));){
            String line;
            boolean toAdd = false;
            while ((line = reader.readLine()) != null) {
                if (line.contains("[Typedef]")) {
                    break;
                }
                if (line.contains("[Term]")) {
                    toAdd = true;
                }
                if (toAdd) {
                    bText.append(line);
                    bText.append("\n");
                    continue;
                }
                if (line.startsWith("format-version")) {
                    this.formatVersion = line.substring(15).trim();
                }
                if (!line.startsWith("data-version")) continue;
                this.ReleaseDate = line.substring(13).trim();
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return bText.toString();
    }

    public List<Term> getAllTerms() {
        String text = this.parseOboFile();
        String[] OboTerms = text.split("\\[Term\\]");
        ArrayList<Term> termsList = new ArrayList<Term>();
        for (String ot : OboTerms) {
            termsList.add(this.initTerm(ot));
        }
        return termsList;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getReleaseDate() {
        return this.ReleaseDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<Term> getLeafTerms() {
        if (this.leafTerms.isEmpty()) {
            HashSet<Term> allSet = new HashSet<Term>();
            HashSet<Term> nonLeafSet = new HashSet<Term>();
            allSet.addAll(this.getAllTerms());
            nonLeafSet.addAll(this.nonLeafTerms);
            allSet.removeAll(nonLeafSet);
            this.leafTerms.addAll(allSet);
        }
        return this.leafTerms;
    }
}

