/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Term {
    private boolean isObsolete;
    private String id;
    private String name;
    private String namespace;
    private List<Term> parentTerms;
    private List<String> altIDList;

    public Term(String id, String name) {
        this.id = id;
        this.name = name;
        this.parentTerms = new ArrayList<Term>();
        this.altIDList = new ArrayList<String>();
    }

    public Term(boolean isObsolete, String id, String name, List<Term> parentTerms) {
        this(id, name);
        this.isObsolete = isObsolete;
        this.parentTerms = parentTerms;
    }

    public Term(boolean isObsolete, String id, String name, String namespace, List<Term> parentTerms) {
        this(isObsolete, id, name, parentTerms);
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isChildOf(Term other) {
        return this.parentTerms.contains(other);
    }

    public boolean isParentOf(Term other) {
        return other.parentTerms.contains(this);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Term> getParentTerms() {
        return this.parentTerms;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Term)) {
            return false;
        }
        Term term = (Term)other;
        return this.id.equals(term.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public String toString() {
        return String.format("Term id: %s\nName: %s", this.id, this.name);
    }

    public boolean isIsObsolete() {
        return this.isObsolete;
    }

    public List<String> getAltIDList() {
        return this.altIDList;
    }

    public void setAltIDList(List<String> altIDList) {
        this.altIDList = altIDList;
    }
}

