/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;

public class FtpConnection {
    private static FtpConnection ftpConnection = null;
    private FTPClient ftpClient = new FTPClient();
    private String ftpAddress;
    private String user = "anonymous";
    private String password = "dingo.lab180@gmail.com";
    int port = 21;

    private FtpConnection() {
    }

    private FtpConnection(String ftpAddress) {
        this();
        this.ftpAddress = ftpAddress;
    }

    private FtpConnection(String ftpAddress, String user, String password, int port) {
        this.ftpAddress = ftpAddress;
        this.user = user;
        this.password = password;
        this.port = port;
    }

    public void connectAndLogin() throws IOException {
        this.ftpClient.connect(this.ftpAddress, this.port);
        this.ftpClient.login(this.user, this.password);
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.setFileType(2);
    }

    public void disconnect() {
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
            catch (IOException f) {
                System.out.println(f.getMessage());
            }
        }
    }

    public Date retrieveLastModTimeFromServer(String subFolder, String fileName) throws IOException {
        boolean isChanged = this.ftpClient.changeWorkingDirectory(subFolder);
        if (!isChanged) {
            return null;
        }
        String modDate = this.ftpClient.getModificationTime(fileName);
        this.ftpClient.changeWorkingDirectory("/");
        return FtpConnection.formatServerDate(modDate);
    }

    public static Date formatServerDate(String unformattedDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date formattedDate = null;
        try {
            formattedDate = dateFormat.parse(unformattedDate.substring(unformattedDate.indexOf(" ") + 1));
        }
        catch (ParseException ex) {
            Logger.getGlobal().info(ex.getMessage());
        }
        return formattedDate;
    }

    public static FtpConnection getInstance() {
        if (ftpConnection == null) {
            ftpConnection = new FtpConnection();
        }
        return ftpConnection;
    }

    public static FtpConnection getInstance(String ftpAddress) {
        if (ftpConnection == null) {
            ftpConnection = new FtpConnection(ftpAddress);
        }
        return ftpConnection;
    }

    public static FtpConnection getInstance(String ftpAddress, String user, String password, int port) {
        if (ftpConnection == null) {
            ftpConnection = new FtpConnection(ftpAddress, user, password, port);
        }
        return ftpConnection;
    }

    public FTPClient getFTPClient() {
        return this.ftpClient;
    }

    public String getFtpAddress() {
        return this.ftpAddress;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public void setFtpAddress(String ftpAddress) {
        this.ftpAddress = ftpAddress;
    }
}

