/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import update.IFileDownload;

public class GOFileDownloader
implements IFileDownload {
    private String fileAddress;
    private String downloadFolder;
    private String formatVersion;
    private Date releaseDate;

    public GOFileDownloader(String fileAddress, String downloadFolder) {
        this.fileAddress = fileAddress;
        this.downloadFolder = downloadFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String fileName) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            InputStream inStream = fileName.endsWith(".obo") ? new URL(this.fileAddress).openStream() : new GZIPInputStream(new URL(this.fileAddress).openStream());
            reader = new BufferedReader(new InputStreamReader(inStream));
            writer = new BufferedWriter(new FileWriter(this.downloadFolder + fileName));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("!gaf-version:") || line.startsWith("format-version")) {
                    this.formatVersion = line.split("\\s")[1];
                }
                if (line.startsWith("data-version:") || line.startsWith("!Date Generated by GOC:") || line.startsWith("!date-generated:")) {
                    String strRelease = line.split(":")[1].trim();
                    if (strRelease.contains("T")) {
                        strRelease = strRelease.split("T")[0];
                    }
                    if (strRelease.contains("/")) {
                        strRelease = strRelease.split("/")[1];
                    }
                    try {
                        this.releaseDate = new SimpleDateFormat("yyyy-MM-dd").parse(strRelease);
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(GOFileDownloader.class.getName()).log(Level.INFO, "Unparsable date " + strRelease, "");
                    }
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            Logger.getLogger(GOFileDownloader.class.getName()).log(Level.SEVERE, "File can not be found " + this.fileAddress, "");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
    }

    @Override
    public String getFormatVersion() {
        return this.formatVersion;
    }

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }
}

