/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class LocalFilesManager {
    private String directory;
    private String logFile;

    public LocalFilesManager(String directory, String logFile) {
        this.directory = directory;
        this.logFile = logFile;
    }

    public static Date convertStringToDate(String dateAsStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = formatter.parse(dateAsStr);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
        }
        return date;
    }

    public String[] getAllFilesInDirectory() {
        File dir = new File(this.directory);
        return dir.list();
    }

    public static Date extractOboReleaseDate(String pathToObo) {
        String timeStr = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(pathToObo));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("data-version")) {
                    timeStr = line.split("/")[1];
                } else {
                    if (!line.startsWith("!Generated: ")) continue;
                    timeStr = line.split("\\s+")[1];
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        Date releaseDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            releaseDate = formatter.parse(timeStr);
        }
        catch (ParseException e) {
            return null;
        }
        return releaseDate;
    }

    public boolean saveLastModTimeToFile(Date lastModDate, String fileName) {
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(new File(this.logFile), true));){
            writer.println(fileName + "=" + String.valueOf(lastModDate));
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public Date retrieveLastModDateFromFile(String fileName) {
        System.out.println("File name: " + fileName);
        Date lastModTime = null;
        ArrayList<String> entries = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.logFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(fileName)) continue;
                entries.add(line.split("=")[1]);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        if (!entries.isEmpty()) {
            String reprDate = (String)entries.get(entries.size() - 1);
            try {
                lastModTime = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy").parse(reprDate);
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
            }
        }
        return lastModTime;
    }

    public static boolean renameFile(String oldName, String newName) {
        boolean bRet = true;
        try (BufferedReader reader = new BufferedReader(new FileReader(oldName));
             BufferedWriter writer = new BufferedWriter(new FileWriter(newName));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            File oldFile = new File(oldName);
            boolean bValue = oldFile.delete();
            if (bValue) {
                System.out.println("File" + oldName + " renamed successfully to" + newName + "!");
            } else {
                System.out.println("Cannot rename file " + oldName);
                bRet = false;
            }
        }
        catch (IOException ex) {
            bRet = false;
        }
        return bRet;
    }
}

