/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.net.ftp.FTPClient;
import update.FtpConnection;
import update.IFileDownload;

public class UniProtFileDownloader
implements IFileDownload {
    private String ftpAddress;
    private String folderOnServer;
    private String formatVersion;
    private String downloadFolder;
    private Date releaseDate;
    private FtpConnection connection;

    public UniProtFileDownloader(FtpConnection connection, String ftpAddress, String folderOnServer, String downloadFolder) {
        this.connection = connection;
        this.ftpAddress = ftpAddress;
        this.folderOnServer = folderOnServer;
        this.downloadFolder = downloadFolder;
    }

    private static Date convertStringToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = formatter.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private void unzipGoAnnotation(String gzipFile, String outFile) {
        System.out.println("Unzipping file " + gzipFile);
        UnGZipFile unGZipFile = new UnGZipFile(gzipFile, outFile);
        unGZipFile.unzipFile();
        boolean deleteFile = new File(gzipFile).delete();
        if (deleteFile) {
            System.out.println(gzipFile + " has been deleted!");
        } else {
            System.out.println("Can't delete " + gzipFile + " !");
        }
    }

    @Override
    public void downloadFile(String fileName) {
        FTPClient ftpClient = this.connection.getFTPClient();
        this.connection.setFtpAddress(this.ftpAddress);
        try {
            this.connection.connectAndLogin();
            boolean isDirExists = ftpClient.changeWorkingDirectory(this.folderOnServer);
            if (!isDirExists) {
                System.out.println("Folder " + this.folderOnServer + " has not been found!");
                return;
            }
            String downloadedFile = this.downloadFolder + fileName;
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(new File(downloadedFile)));
            boolean success = ftpClient.retrieveFile(fileName, output);
            String strRelease = ftpClient.getModificationTime(fileName);
            this.releaseDate = UniProtFileDownloader.convertStringToDate(strRelease);
            if (!success) {
                System.out.println("File downloading has been failed!");
                return;
            }
            System.out.println("File " + fileName + " has been downloaded successfully!");
            ((OutputStream)output).close();
            if (fileName.endsWith(".gz")) {
                this.unzipGoAnnotation(downloadedFile, downloadedFile.substring(0, downloadedFile.lastIndexOf(".")));
            }
            ftpClient.changeWorkingDirectory("/");
            this.connection.disconnect();
        }
        catch (IOException ex) {
            Logger.getLogger(UniProtFileDownloader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getFormatVersion() {
        return "";
    }

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getFtpAddress() {
        return this.ftpAddress;
    }

    public String getFolderOnServer() {
        return this.folderOnServer;
    }

    public String getDownloadFolder() {
        return this.downloadFolder;
    }

    private class UnGZipFile {
        private final String gzipFile;
        private final String txtFile;

        private UnGZipFile(String gzipFile, String txtFile) {
            this.gzipFile = gzipFile;
            this.txtFile = txtFile;
        }

        private void unzipFile() {
            try {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.gzipFile))));
                     BufferedWriter writer = new BufferedWriter(new FileWriter(this.txtFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
                System.out.println("");
                System.out.println("Done!");
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }
}

